/*
 * Decompiled with CFR 0.152.
 */
package one.lindenberg.guacamole;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import one.lindenberg.guacamole.LindenbergBackupConfiguration;
import one.lindenberg.guacamole.LindenbergBackupTunnel;
import one.lindenberg.guacamole.LindenbergBackupUserContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.environment.Environment;
import org.apache.guacamole.environment.LocalEnvironment;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.auth.simple.SimpleAuthenticationProvider;
import org.apache.guacamole.net.event.TunnelCloseEvent;
import org.apache.guacamole.net.event.TunnelConnectEvent;
import org.apache.guacamole.net.event.listener.Listener;
import org.apache.guacamole.properties.GuacamoleProperty;
import org.apache.guacamole.properties.StringGuacamoleProperty;
import org.apache.guacamole.protocol.GuacamoleConfiguration;

public class LindenbergBackupAuthenticationProvider
extends SimpleAuthenticationProvider
implements Listener {
    public static Environment environment = null;
    public static final StringGuacamoleProperty Url = new StringGuacamoleProperty(){

        public String getName() {
            return "hyperv-url-connections";
        }
    };
    public static final StringGuacamoleProperty Domain = new StringGuacamoleProperty(){

        public String getName() {
            return "hyperv-domain";
        }
    };
    public static final StringGuacamoleProperty User = new StringGuacamoleProperty(){

        public String getName() {
            return "hyperv-user";
        }
    };
    public static final StringGuacamoleProperty Password = new StringGuacamoleProperty(){

        public String getName() {
            return "hyperv-password";
        }
    };
    public static final StringGuacamoleProperty ServerLayout = new StringGuacamoleProperty(){

        public String getName() {
            return "hyperv-server-layout";
        }
    };
    public static final StringGuacamoleProperty Console = new StringGuacamoleProperty(){

        public String getName() {
            return "console";
        }
    };
    public static final StringGuacamoleProperty ConsoleAudio = new StringGuacamoleProperty(){

        public String getName() {
            return "console-audio";
        }
    };
    public static final StringGuacamoleProperty IgnoreCert = new StringGuacamoleProperty(){

        public String getName() {
            return "hyperv-ignore-cert";
        }
    };
    public static final StringGuacamoleProperty Security = new StringGuacamoleProperty(){

        public String getName() {
            return "hyperv-security";
        }
    };
    private Map<String, GuacamoleConfiguration> configs;

    public String getIdentifier() {
        return "GuacamoleLindenbergBackupProvider";
    }

    private void copyParameter(GuacamoleConfiguration gc, String name, JsonObject json, String prop) {
        String value = null;
        try {
            value = json.getString(prop);
        }
        catch (Exception e) {
            try {
                value = ((JsonValue)json.get(prop)).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        gc.setParameter(name, value);
    }

    private void defRequiredParameter(GuacamoleConfiguration gc, String name, StringGuacamoleProperty property) {
        String setting = null;
        try {
            setting = (String)environment.getRequiredProperty((GuacamoleProperty)property);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (setting == null) {
            LindenbergBackupAuthenticationProvider.debug("undefined property: " + property.getName());
        }
        gc.setParameter(name, setting);
    }

    private void defOptionalParameter(GuacamoleConfiguration gc, String name, StringGuacamoleProperty property) {
        String setting = null;
        try {
            setting = (String)environment.getProperty((GuacamoleProperty)property);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        if (setting == null) {
            return;
        }
        gc.setParameter(name, setting);
    }

    public static void debug(String s) {
        System.out.println("LindenbergBackup - " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()) + ":" + s);
    }

    public static HttpURLConnection getConnection(Credentials credentials, String token, String suffix) throws GuacamoleException, IOException {
        URL url = new URL((String)environment.getRequiredProperty((GuacamoleProperty)Url) + suffix);
        LindenbergBackupAuthenticationProvider.debug(url.toString());
        if (token == null && (credentials == null || credentials.getUsername() == null || credentials.getPassword() == null)) {
            return null;
        }
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        String authString = token != null ? token : credentials.getUsername() + ":" + credentials.getPassword();
        byte[] authEncBytes = Base64.encodeBase64(authString.getBytes());
        String authStringEnc = new String(authEncBytes);
        con.setRequestProperty("Authorization", (token != null ? "XVMToken " : "Basic ") + authStringEnc);
        con.setRequestMethod("GET");
        con.setUseCaches(false);
        return con;
    }

    private void requestChange(boolean close, GuacamoleTunnel tunnel, Credentials credentials) throws IOException, GuacamoleException {
        if (tunnel instanceof LindenbergBackupTunnel) {
            GuacamoleConfiguration configuration = ((LindenbergBackupTunnel)tunnel).config;
            if (!(configuration instanceof LindenbergBackupConfiguration)) {
                return;
            }
            ((LindenbergBackupConfiguration)configuration).stateChange(close, tunnel, credentials);
        }
    }

    public UserContext getUserContext(AuthenticatedUser authenticatedUser) throws GuacamoleException {
        LindenbergBackupAuthenticationProvider.debug("getUserContext");
        if (this.configs == null) {
            return null;
        }
        return new LindenbergBackupUserContext((AuthenticationProvider)this, authenticatedUser.getIdentifier(), this.configs);
    }

    public UserContext updateUserContext(UserContext context, AuthenticatedUser authorizedUser, Credentials credentials) throws GuacamoleException {
        LindenbergBackupAuthenticationProvider.debug("updateUserContext");
        return new LindenbergBackupUserContext((AuthenticationProvider)this, authorizedUser.getIdentifier(), this.getAuthorizedConfigurations(authorizedUser.getCredentials()));
    }

    public LindenbergBackupConfiguration parseJson(JsonObject result, Credentials credentials, String token) {
        String name = result.getString("name");
        LindenbergBackupConfiguration gc = new LindenbergBackupConfiguration(name, credentials, token);
        gc.setProtocol(result.getString("protocol"));
        this.copyParameter(gc, "hostname", result, "host");
        this.copyParameter(gc, "port", result, "port");
        if (gc.getProtocol().equals("rdp")) {
            this.defRequiredParameter(gc, "username", User);
            this.defRequiredParameter(gc, "domain", Domain);
            this.defRequiredParameter(gc, "password", Password);
            this.defRequiredParameter(gc, "server-layout", ServerLayout);
            this.defOptionalParameter(gc, "console", Console);
            this.defOptionalParameter(gc, "console-audio", ConsoleAudio);
            this.defOptionalParameter(gc, "ignore-cert", IgnoreCert);
            this.defRequiredParameter(gc, "security", Security);
        }
        String id = result.get("id") != null ? result.getString("id") : null;
        this.copyParameter(gc, ".enhancedmode", result, "enhancedmode");
        if (id != null) {
            this.copyParameter(gc, ".id", result, "id");
            this.copyParameter(gc, ".state", result, "state");
            if (result.getBoolean("vm")) {
                name = name + " (" + result.getString("state") + ")";
            }
        }
        this.copyParameter(gc, ".name", result, "name");
        this.copyParameter(gc, ".identifier", result, "identifier");
        if (token == null) {
            this.copyParameter(gc, ".group", result, "group");
            this.copyParameter(gc, ".user", result, "user");
            this.copyParameter(gc, ".backup", result, "backup");
        }
        this.copyParameter(gc, ".vm", result, "vm");
        this.copyParameter(gc, ".image", result, "image");
        return gc;
    }

    public Map<String, GuacamoleConfiguration> parseJson(InputStream input, Credentials credentials, String token) {
        LindenbergBackupAuthenticationProvider.debug("before json parsing");
        HashMap<String, GuacamoleConfiguration> map = new HashMap<String, GuacamoleConfiguration>();
        JsonReader rdr = Json.createReader(input);
        JsonArray array = rdr.readArray();
        LindenbergBackupAuthenticationProvider.debug("after json parsing");
        for (JsonObject result : array.getValuesAs(JsonObject.class)) {
            LindenbergBackupConfiguration gc = this.parseJson(result, credentials, token);
            map.put(gc.name, gc);
        }
        LindenbergBackupAuthenticationProvider.debug("before return");
        this.configs = map;
        return map;
    }

    public Map<String, GuacamoleConfiguration> getAuthorizedConfigurations(Credentials credentials) throws GuacamoleException {
        try {
            String token;
            LindenbergBackupAuthenticationProvider.debug("begin getAuthorizedConfigurations");
            if (environment == null) {
                environment = new LocalEnvironment();
            }
            String string = token = credentials.getRequest() != null ? credentials.getRequest().getParameter("token") : null;
            if (token != null) {
                credentials.setUsername(token);
            } else if (credentials == null || credentials.getUsername() == null || credentials.getPassword() == null) {
                return null;
            }
            HttpURLConnection con = LindenbergBackupAuthenticationProvider.getConnection(credentials, token, "?guacamole");
            LindenbergBackupAuthenticationProvider.debug("before getResponseCode");
            int status = con.getResponseCode();
            LindenbergBackupAuthenticationProvider.debug("after getResponseCode");
            if (status != 200) {
                return null;
            }
            Map<String, GuacamoleConfiguration> map = this.parseJson(con.getInputStream(), credentials, token);
            this.configs = map;
            return map;
        }
        catch (Throwable ex) {
            LindenbergBackupAuthenticationProvider.debug("exception");
            ex.printStackTrace();
            throw new GuacamoleException(ex);
        }
    }

    public void handleEvent(Object event) throws GuacamoleException {
        try {
            if (event instanceof TunnelCloseEvent) {
                TunnelCloseEvent closeevent = (TunnelCloseEvent)event;
                this.requestChange(true, closeevent.getTunnel(), closeevent.getCredentials());
            } else if (event instanceof TunnelConnectEvent) {
                TunnelConnectEvent connectevent = (TunnelConnectEvent)event;
                this.requestChange(false, connectevent.getTunnel(), connectevent.getCredentials());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

