/*
 * Decompiled with CFR 0.152.
 */
package one.lindenberg.guacamole;

import java.net.HttpURLConnection;
import java.util.Timer;
import java.util.TimerTask;
import one.lindenberg.guacamole.LindenbergBackupAuthenticationProvider;
import one.lindenberg.guacamole.LindenbergBackupConnection;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.protocol.GuacamoleClientInformation;
import org.apache.guacamole.protocol.GuacamoleConfiguration;

public class LindenbergBackupConfiguration
extends GuacamoleConfiguration {
    private static final long serialVersionUID = -4095200038178609032L;
    public boolean logparameters = false;
    String name;
    private Credentials credentials;
    private String token;
    private Timer timer;
    protected LindenbergBackupConnection connection;
    protected GuacamoleClientInformation info;
    protected GuacamoleTunnel tunnel;

    private void debug(String s) {
        LindenbergBackupAuthenticationProvider.debug(s + "-" + this.name);
    }

    LindenbergBackupConfiguration(String name, Credentials credentials, String token) {
        this.name = name;
        this.credentials = credentials;
        this.token = token;
    }

    public boolean updateEnhancedMode(HttpURLConnection con) {
        String id = this.getParameter(".id");
        String oldmode = this.getParameter(".enhancedmode");
        String enhancedMode = con.getHeaderField("X-EnhancedMode");
        if (enhancedMode == null) {
            enhancedMode = "false";
            this.debug("enhancedMode missing");
        }
        enhancedMode = enhancedMode.toLowerCase();
        this.setParameter(".enhancedmode", enhancedMode);
        if (enhancedMode.equals("true")) {
            this.setParameter("preconnection-blob", id + ";EnhancedMode=1");
        } else {
            this.setParameter("preconnection-blob", id);
        }
        this.debug(enhancedMode + "," + this.getParameter("preconnection-blob"));
        return !enhancedMode.equals(oldmode);
    }

    public void createVirtualMachine() {
        String image = this.getParameter(".image");
        if (image == null) {
            return;
        }
        try {
            HttpURLConnection con = LindenbergBackupAuthenticationProvider.getConnection(this.credentials, null, "CreateVirtualMachine");
            con.setRequestMethod("POST");
            con.setRequestProperty("X-Image", image);
            this.debug("CreateVirtualMachine-response:" + con.getResponseCode() + "-" + image);
            String id = con.getHeaderField("X-GUID");
            this.setParameter(".id", id);
            this.setParameter("port", con.getHeaderField("X-Port"));
            this.setParameter(".name", con.getHeaderField("X-Name"));
            this.updateEnhancedMode(con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void connect(GuacamoleTunnel tunnel, Credentials credentials) {
        this.debug("connect");
        LindenbergTickleTask task = new LindenbergTickleTask(this, tunnel);
        this.timer = new Timer(this.name);
        this.timer.scheduleAtFixedRate((TimerTask)task, 0L, 30000L);
    }

    public void close(Credentials credentials) {
        this.timer.cancel();
        this.timer = null;
    }

    public void stateChange(boolean close, GuacamoleTunnel tunnel, Credentials credentials) {
        if (close) {
            this.close(credentials);
        } else {
            this.connect(tunnel, credentials);
        }
    }

    public class LindenbergTickleTask
    extends TimerTask {
        private LindenbergBackupConfiguration configuration;
        private GuacamoleTunnel tunnel;
        private int counter = 0;

        public LindenbergTickleTask(LindenbergBackupConfiguration configuration, GuacamoleTunnel tunnel) {
            this.configuration = configuration;
            this.tunnel = tunnel;
        }

        @Override
        public void run() {
            String vmid = this.configuration.getParameter(".id");
            if (vmid == null) {
                return;
            }
            try {
                HttpURLConnection con = LindenbergBackupAuthenticationProvider.getConnection(LindenbergBackupConfiguration.this.credentials, this.configuration.token, "?guacamole");
                con.setRequestMethod("POST");
                con.setRequestProperty("X-VMID", vmid);
                LindenbergBackupConfiguration.this.debug("TickleTask-response:" + con.getResponseCode() + "-" + vmid);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

