/*
 * Decompiled with CFR 0.152.
 */
package one.lindenberg.guacamole;

import java.util.HashMap;
import java.util.Map;
import one.lindenberg.guacamole.LindenbergBackupAuthenticationProvider;
import one.lindenberg.guacamole.LindenbergBackupConfiguration;
import one.lindenberg.guacamole.LindenbergBackupTunnel;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.environment.LocalEnvironment;
import org.apache.guacamole.net.GuacamoleSocket;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.net.InetGuacamoleSocket;
import org.apache.guacamole.net.SSLGuacamoleSocket;
import org.apache.guacamole.net.auth.GuacamoleProxyConfiguration;
import org.apache.guacamole.net.auth.simple.SimpleConnection;
import org.apache.guacamole.protocol.ConfiguredGuacamoleSocket;
import org.apache.guacamole.protocol.GuacamoleClientInformation;
import org.apache.guacamole.protocol.GuacamoleConfiguration;

public class LindenbergBackupConnection
extends SimpleConnection {
    private GuacamoleConfiguration config;
    private String status;

    public LindenbergBackupConnection() {
    }

    public LindenbergBackupConnection(String name, String identifier, LindenbergBackupConfiguration config, String status) {
        this.setName(name);
        this.setIdentifier(identifier);
        this.setConfiguration(config);
        this.config = config;
        this.status = status;
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Status", this.status);
        return map;
    }

    private void displayConfig(String name, GuacamoleConfiguration gc) {
        StringBuilder sb = new StringBuilder().append(name).append(":");
        for (String prop : gc.getParameterNames()) {
            sb.append(prop).append("=").append(gc.getParameter(prop)).append(",");
        }
        LindenbergBackupAuthenticationProvider.debug(sb.toString());
    }

    public GuacamoleSocket getsocket(GuacamoleClientInformation info) throws GuacamoleException {
        ConfiguredGuacamoleSocket socket;
        LocalEnvironment environment = new LocalEnvironment();
        GuacamoleProxyConfiguration proxyConfig = environment.getDefaultGuacamoleProxyConfiguration();
        String hostname = proxyConfig.getHostname();
        int port = proxyConfig.getPort();
        switch (proxyConfig.getEncryptionMethod()) {
            case SSL: {
                socket = new ConfiguredGuacamoleSocket((GuacamoleSocket)new SSLGuacamoleSocket(hostname, port), this.config, info);
                break;
            }
            case NONE: {
                socket = new ConfiguredGuacamoleSocket((GuacamoleSocket)new InetGuacamoleSocket(hostname, port), this.config, info);
                break;
            }
            default: {
                throw new GuacamoleServerException("Unimplemented encryption method.");
            }
        }
        return socket;
    }

    public GuacamoleTunnel connect(GuacamoleClientInformation info) throws GuacamoleException {
        GuacamoleConfiguration config = this.getConfiguration();
        LindenbergBackupTunnel tunnel = null;
        LindenbergBackupConfiguration lconfig = null;
        if (config == null) {
            throw new NullPointerException("configuration null");
        }
        this.displayConfig("connect", config);
        if (config instanceof LindenbergBackupConfiguration) {
            String id = config.getParameter(".id");
            if (config.getParameter(".enhancedmode").equals("true")) {
                config.setParameter("preconnection-blob", id + ";EnhancedMode=1");
            } else {
                config.setParameter("preconnection-blob", id);
            }
            lconfig = (LindenbergBackupConfiguration)config;
            lconfig.connection = this;
            lconfig.info = info;
            String vm = config.getParameter(".vm");
            if (vm.equals("false")) {
                lconfig.createVirtualMachine();
            }
        }
        tunnel = new LindenbergBackupTunnel(this.getsocket(info), config, this);
        if (lconfig != null) {
            lconfig.tunnel = tunnel;
        }
        return tunnel;
    }
}

