/*
 * Decompiled with CFR 0.152.
 */
package one.lindenberg.guacamole;

import java.util.UUID;
import one.lindenberg.guacamole.LindenbergBackupAuthenticationProvider;
import one.lindenberg.guacamole.LindenbergBackupConnection;
import one.lindenberg.guacamole.LindenbergBackupSocket;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.AbstractGuacamoleTunnel;
import org.apache.guacamole.net.GuacamoleSocket;
import org.apache.guacamole.protocol.FilteredGuacamoleSocket;
import org.apache.guacamole.protocol.GuacamoleClientInformation;
import org.apache.guacamole.protocol.GuacamoleConfiguration;
import org.apache.guacamole.protocol.GuacamoleFilter;
import org.apache.guacamole.protocol.GuacamoleInstruction;

public class LindenbergBackupTunnel
extends AbstractGuacamoleTunnel {
    LindenbergBackupConnection connection;
    GuacamoleConfiguration config;
    GuacamoleSocket socket;
    LindenbergBackupFilter filter = new LindenbergBackupFilter();
    UUID uuid;

    public UUID getUUID() {
        return this.uuid;
    }

    public GuacamoleSocket getSocket() {
        LindenbergBackupAuthenticationProvider.debug("LindenbergBackupTunnel.getSocket()");
        return new LindenbergBackupSocket(this);
    }

    public void reconnect(GuacamoleClientInformation info) {
        LindenbergBackupAuthenticationProvider.debug("LindenbergBackupTunnel.reconnect()");
        GuacamoleSocket gcsocket = this.socket;
        this.socket = null;
        try {
            gcsocket.close();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
        try {
            this.filter = new LindenbergBackupFilter();
            this.filter.discardinstruction = true;
            this.socket = new FilteredGuacamoleSocket(this.connection.getsocket(info), (GuacamoleFilter)this.filter, (GuacamoleFilter)this.filter);
            this.filter.discardinstruction = false;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    public LindenbergBackupTunnel(GuacamoleSocket socket, GuacamoleConfiguration config, LindenbergBackupConnection connection) {
        this.connection = connection;
        this.config = config;
        this.uuid = UUID.randomUUID();
        this.socket = new FilteredGuacamoleSocket(socket, (GuacamoleFilter)this.filter, (GuacamoleFilter)this.filter);
    }

    class LindenbergBackupFilter
    implements GuacamoleFilter {
        protected boolean discardinstruction = false;
        private int counter = 3;

        public GuacamoleInstruction filter(GuacamoleInstruction instruction) throws GuacamoleException {
            if (!this.discardinstruction) {
                if (--this.counter >= 0) {
                    LindenbergBackupAuthenticationProvider.debug("processing instruction");
                }
                return instruction;
            }
            LindenbergBackupAuthenticationProvider.debug("discarding instruction");
            return null;
        }

        LindenbergBackupFilter() {
        }
    }
}

