/*
 * Decompiled with CFR 0.152.
 */
package one.lindenberg.guacamole;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import one.lindenberg.guacamole.LindenbergBackupConfiguration;
import one.lindenberg.guacamole.LindenbergBackupConnection;
import one.lindenberg.guacamole.LindenbergConnectionGroup;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.form.Form;
import org.apache.guacamole.net.auth.ActiveConnection;
import org.apache.guacamole.net.auth.ActivityRecord;
import org.apache.guacamole.net.auth.ActivityRecordSet;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.ConnectionGroup;
import org.apache.guacamole.net.auth.ConnectionRecord;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.SharingProfile;
import org.apache.guacamole.net.auth.User;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.auth.UserGroup;
import org.apache.guacamole.net.auth.simple.SimpleActivityRecordSet;
import org.apache.guacamole.net.auth.simple.SimpleConnectionDirectory;
import org.apache.guacamole.net.auth.simple.SimpleConnectionGroupDirectory;
import org.apache.guacamole.net.auth.simple.SimpleDirectory;
import org.apache.guacamole.net.auth.simple.SimpleUser;
import org.apache.guacamole.net.auth.simple.SimpleUserDirectory;
import org.apache.guacamole.protocol.GuacamoleConfiguration;

public class LindenbergBackupUserContext
implements UserContext {
    private static final String ROOT_IDENTIFIER = "ROOT";
    private static final String VM_IDENTIFIER = "(Virtual Machines)";
    private final AuthenticationProvider authProvider;
    private final User self;
    private final Directory<User> userDirectory;
    public final Directory<ConnectionGroup> connectionGroupDirectory;
    public final Directory<Connection> connectionDirectory;
    private LindenbergConnectionGroup rootGroup;
    private LindenbergConnectionGroup vmGroup;

    public LindenbergBackupUserContext(AuthenticationProvider authProvider, Map<String, GuacamoleConfiguration> configs) {
        this(authProvider, UUID.randomUUID().toString(), configs);
    }

    public LindenbergBackupUserContext(AuthenticationProvider authProvider, String username, Map<String, GuacamoleConfiguration> configs) {
        System.out.println("LindenbergBackupUserContext(" + username + ")");
        boolean nogroups = username.contains("-");
        ArrayList<String> connectionIdentifiers = new ArrayList<String>(configs.size());
        HashMap<String, LindenbergConnectionGroup> connectionGroups = new HashMap<String, LindenbergConnectionGroup>();
        this.rootGroup = new LindenbergConnectionGroup(ROOT_IDENTIFIER, ROOT_IDENTIFIER, null);
        connectionGroups.put(ROOT_IDENTIFIER, this.rootGroup);
        ArrayList<LindenbergBackupConnection> connections = new ArrayList<LindenbergBackupConnection>(configs.size());
        for (Map.Entry<String, GuacamoleConfiguration> configEntry : configs.entrySet()) {
            LindenbergBackupConfiguration config = (LindenbergBackupConfiguration)configEntry.getValue();
            String identifier = config.getParameter(".identifier");
            LindenbergBackupConnection connection = new LindenbergBackupConnection(config.getParameter(".name"), identifier, config, config.getParameter(".state"));
            String group = config.getParameter(".group");
            String backup = config.getParameter(".backup");
            String user = config.getParameter(".user");
            if (group != null) {
                backup = group;
                user = null;
            }
            if (nogroups) {
                this.rootGroup.addConnection((Connection)connection);
            } else {
                connection.setParentIdentifier(backup);
                LindenbergConnectionGroup cgbackup = (LindenbergConnectionGroup)((Object)connectionGroups.get(backup));
                if (cgbackup == null) {
                    cgbackup = new LindenbergConnectionGroup(backup, backup, ROOT_IDENTIFIER);
                    connectionGroups.put(backup, cgbackup);
                    if (user == null || "null".equals(user)) {
                        this.rootGroup.addConnectionGroup((ConnectionGroup)cgbackup);
                    } else {
                        cgbackup.setParentIdentifier(user);
                        LindenbergConnectionGroup cguser = (LindenbergConnectionGroup)((Object)connectionGroups.get(user));
                        if (cguser == null) {
                            cguser = new LindenbergConnectionGroup(user, user, ROOT_IDENTIFIER);
                            connectionGroups.put(user, cguser);
                            this.rootGroup.addConnectionGroup((ConnectionGroup)cguser);
                        }
                        cguser.addConnectionGroup((ConnectionGroup)cgbackup);
                    }
                }
                cgbackup.addConnection((Connection)connection);
            }
            connections.add(connection);
            connectionIdentifiers.add(identifier);
        }
        HashSet<LindenbergConnectionGroup> cgcollection = new HashSet<LindenbergConnectionGroup>();
        for (LindenbergConnectionGroup entry : connectionGroups.values()) {
            cgcollection.add(entry);
        }
        this.self = new SimpleUser(username, new HashSet(), Collections.singleton(this.rootGroup.getIdentifier()));
        this.userDirectory = new SimpleUserDirectory(this.self);
        this.connectionDirectory = new SimpleConnectionDirectory(connections);
        this.connectionGroupDirectory = new SimpleConnectionGroupDirectory(cgcollection);
        this.authProvider = authProvider;
    }

    public User self() {
        return this.self;
    }

    public Object getResource() throws GuacamoleException {
        return null;
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return this.authProvider;
    }

    public Directory<User> getUserDirectory() throws GuacamoleException {
        return this.userDirectory;
    }

    public Directory<Connection> getConnectionDirectory() throws GuacamoleException {
        return this.connectionDirectory;
    }

    public Directory<ConnectionGroup> getConnectionGroupDirectory() throws GuacamoleException {
        return this.connectionGroupDirectory;
    }

    public ConnectionGroup getRootConnectionGroup() throws GuacamoleException {
        return this.rootGroup;
    }

    public Directory<SharingProfile> getSharingProfileDirectory() throws GuacamoleException {
        return new SimpleDirectory();
    }

    public Directory<ActiveConnection> getActiveConnectionDirectory() throws GuacamoleException {
        return new SimpleDirectory();
    }

    public ActivityRecordSet<ConnectionRecord> getConnectionHistory() throws GuacamoleException {
        return new SimpleActivityRecordSet();
    }

    public ActivityRecordSet<ActivityRecord> getUserHistory() throws GuacamoleException {
        return new SimpleActivityRecordSet();
    }

    public Collection<Form> getUserAttributes() {
        return Collections.emptyList();
    }

    public Collection<Form> getConnectionAttributes() {
        return Collections.emptyList();
    }

    public Collection<Form> getConnectionGroupAttributes() {
        return Collections.emptyList();
    }

    public Collection<Form> getSharingProfileAttributes() {
        return Collections.emptyList();
    }

    public void invalidate() {
    }

    public Directory<UserGroup> getUserGroupDirectory() throws GuacamoleException {
        return null;
    }

    public Collection<Form> getUserGroupAttributes() {
        return null;
    }
}

